/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于前后端通信参数构造
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 *************************************************************************************************/

/* global mc_js_map */
/* global mc_remove_json_comments */

/* exported mc_sdk_param */

function mc_sdk_param() {
    var CSTR_KEY_CMD = "CMD";
    var CSTR_KEY_FUNC = "FUNC";
    var CSTR_KEY_PARA = "PARAMS";
    var CSTR_KEY_ID = "NAME_ID";
    var CSTR_KEY_VAL = "VALUE";
    var CSTR_KEY_ATTR = "ATTRS";
    var CSTR_KEY_ATTR_NAME = "ATTR_NAME";
    var CSTR_KEY_ATTR_VAL = "ATTR_VALUE";

    // 定义参数值对象
    function param_val() {
        this.str_value = "";
        this.map_attributes = new mc_js_map();
    }
    var map_params = new mc_js_map();
    var str_func = "";
    var str_cmd = "";
    // 默认为简易模式
    var b_easy_flag = true;

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    设置一个数据交换对象中的功能名称
    * 参数:
         @param { Promise<String> } func 功能名称
    * 返回：
    *    @return { Promise<Boolean> }
    *     true 设置成功
    *     false 参数类型错误
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2019.10.23
    *      内容 : 所有代码
    ************************************************************************************************/
    this.set_func = function (func) {
        if (!tool_typeof_judge(func,"STRING")) {
            return false;
        }

        str_func = func;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得数据交换对象中的功能名称
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> } 功能名称
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_func = function () {
        return str_func;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置一个数据交换对象中的命令
   * 参数:
   *    @param { Promise<String> } cmd 命令字，不能为空
   * 返回：
   *    @return { Promise<Boolean> }
   *      true 设置成功
   *      false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_cmd = function (cmd) {
        if (!tool_typeof_judge(cmd,"STRING")) {
            return false;
        }
        str_cmd = cmd;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得数据交换对象中的命令字
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> } 命令字
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_cmd = function () {
        return str_cmd;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置一个数据交换对象中的指定参数值
   * 参数:
   *    @param { Promise<String> } str_param_name 参数名称，用于对象中唯一识别码, 不能为空
   *    @param { Promise<String> } str_param_value 参数值，如果存在旧值，将更新为指定的新值
   * 返回：
   *    @return { Promise<Boolean> }
   *      true 设置成功
   *      false 参数类型错误 或 参数名称为空
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_param_value = function (str_param_name, str_param_value) {
        if (!tool_typeof_judge(str_param_name,"STRING") || 0 === str_param_name.length) {
            return false;
        }
        if (!tool_typeof_judge(str_param_value,"STRING")) {
            return false;
        }

        var key_u = str_param_name.toUpperCase();
        var old_val = map_params.get(key_u);

        // 判断是否已经存在这个key
        if (tool_typeof_judge(old_val,"UNDEFINED")) {
            old_val = new param_val();
        }
        // 存在直接替换value
        old_val.str_value = str_param_value;
        map_params.set(key_u, old_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得数据交换对象中的参数个数
   * 参数:
   *    无
   * 返回：
   *    @returns { Promise<Number> } 参数个数
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_param_cnt = function () {
        return map_params.length();
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    按参数索引，取得数据交换对象中的参数名
   * 参数:
   *    @param { Promise<Number> } ui_param_idx 参数索引
   * 返回：
   *    @return { Promise<String> }
   *      参数名称
   *      null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_param_name = function (ui_param_idx) {
        if (!tool_typeof_judge(ui_param_idx,"NUMBER") || isNaN(ui_param_idx)) {
            return null;
        }
        return map_params.get_key(ui_param_idx);
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    按参数名称，取得数据交换对象中的参数值
   * 参数:
   *    @param { Promise<String> } str_param_name 参数名称
   * 返回：
   *    @return { Promise<String> }
   *      参数值字串
   *      null 参数类型错误 或 名称不存在
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_param_value = function (str_param_name) {
        if (!tool_typeof_judge(str_param_name,"STRING") || 0 === str_param_name.length) {
            return null;
        }

        var key_u = str_param_name.toUpperCase();
        var old_val = map_params.get(key_u);

        if (tool_typeof_judge(old_val,"UNDEFINED")) {
            return null;
        }
        return old_val.str_value;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置一个数据交换对象中的指定参数的属性值
   * 参数:
   *    @param { Promise<String> } str_param_name 参数名称，用于对象中唯一识别码, 不能为空
   *    @param { Promise<String> } str_attr_name 属性名称，同一参数下，用于对象中唯一识别码, 不能为空
   *    @param { Promise<String> } str_attr_value 属性值，如果存在旧值，将更新为指定的新值
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数不符合条件
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_attr_val = function (str_param_name, str_attr_name, str_attr_value) {
        if (!tool_typeof_judge(str_param_name,"STRING") || 0 === str_param_name.length) {
            return false;
        }
        if (!tool_typeof_judge(str_attr_name,"STRING") || 0 === str_attr_name.length) {
            return false;
        }
        if (!tool_typeof_judge(str_attr_value,"STRING")) {
            return false;
        }

        var key_u = str_param_name.toUpperCase();
        var key_attr_u = str_attr_name.toUpperCase();
        var old_val = map_params.get(key_u);

        if ("[object Undefined]" === Object.prototype.toString.call(old_val)) {
            old_val = new param_val();
        }

        old_val.map_attributes.set(key_attr_u, str_attr_value);
        map_params.set(key_u, old_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    按参数名称，取得数据交换对象中的属性个数
   * 参数:
   *    @param { Promise<String> } str_param_name 参数名称，不能为空
   * 返回：
   *    @return { Promise<Number> }
   *      属性个数
   *      0 参数类型错误 或 参数名称不存在
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_attr_cnt = function (str_param_name) {
        if (!tool_typeof_judge(str_param_name,"STRING") || 0 === str_param_name.length) {
            return 0;
        }

        var key_u = str_param_name.toUpperCase();
        var old_val = map_params.get(key_u);

        if (tool_typeof_judge(old_val,"UNDEFINED")) {
            return 0;
        }

        return old_val.map_attributes.length();
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    按参数名称以及属性名称，取得数据交换对象中的属性值
   * 参数:
   *    @param { Promise<String> } str_param_name 参数名称，不能为空
   *    @param { Promise<String> } str_attr_name 属性名称，不能为空
   * 返回：
   *    @returns { Promise<String> }
   *      属性值字串
   *      null 参数类型错误 或 参数不存在
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_attr_val = function (str_param_name, str_attr_name) {
        if (!tool_typeof_judge(str_param_name,"STRING") || 0 === str_param_name.length) {
            return null;
        }
        if (!tool_typeof_judge(str_attr_name,"STRING") || 0 === str_attr_name.length) {
            return null;
        }
        var key_u = str_param_name.toUpperCase();
        var old_val = map_params.get(key_u);

        if (tool_typeof_judge(old_val,"UNDEFINED")) {
            return null;
        }
        return old_val.map_attributes.get(str_attr_name);
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    按参数名称以及属性名称索引，取得数据交换对象中的属性名称
   * 参数:
   *    @param { Promise<String> } str_param_name 参数名称，不能为空
   *    @param { Promise<Number> } ui_idx 参数索引，不能为空
   * 返回：
   *    @return { Promise<String> }
   *     null 参数类型错误 或 参数不存在
   *     属性值字串
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_attr_name = function (str_param_name, ui_idx) {
        if (!tool_typeof_judge(str_param_name,"STRING") || 0 === str_param_name.length) {
            return null;
        }
        if (!tool_typeof_judge(ui_idx,"NUMBER") || isNaN(ui_idx)) {
            return null;
        }
        var key_u = str_param_name.toUpperCase();
        var old_val = map_params.get(key_u);

        if (tool_typeof_judge(old_val,"UNDEFINED")) {
            return null;
        }
        return old_val.map_attributes.get_key(ui_idx);
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    清空数据交换对象
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> } true 设置成功
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_param_clear = function () {
        map_params = new mc_js_map();
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    清空数据交换对象中指定参数下的所有属性
   * 参数:
   *    @param { Promise<String> } str_param_name 参数名称
   * 返回：
   *    @return { Promise<Boolean> }
   *      true 设置成功
   *      false 参数类型错误 或 参数名称不存在
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_param_attr_clear = function (str_param_name) {
        if (!tool_typeof_judge(str_param_name,"STRING")) {
            return false;
        }

        var key_u = str_param_name.toUpperCase();
        var old_val = map_params.get(key_u);

        if (tool_typeof_judge(old_val,"UNDEFINED")) {
            return false;
        }
        old_val.map_attributes = new mc_js_map();
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    将JSON字串转为数据交换对象之前的清空操作
   * 参数:
   *    无
   * 返回：
   *    无
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.reset = function () {
        map_params = new mc_js_map();
        str_func = "";
        str_cmd = "";
        b_easy_flag = true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置map_attributes
   * 参数:
   *    @param { Promise<Object> } ary_attr_pairs attributes对象
   *    @param { Promise<Object> } map_res_attribute 设置attributes对象方法
   * 返回：
   *    无
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.22
   *      内容 : 所有代码
   ************************************************************************************************/
    function decode_attrs(ary_attr_pairs, map_res_attribute) {
        if ("object" === typeof ary_attr_pairs && 0 < ary_attr_pairs.length) {
            for (var idx_attr = 0; idx_attr < ary_attr_pairs.length; idx_attr++) {
                var obj_param_attr = ary_attr_pairs[idx_attr];

                if ("object" !== typeof obj_param_attr || !tool_typeof_judge(obj_param_attr[CSTR_KEY_ATTR_NAME],"STRING") || 0 === obj_param_attr[CSTR_KEY_ATTR_NAME].length) {
                    continue;
                }

                var str_attr_key = obj_param_attr[CSTR_KEY_ATTR_NAME].toUpperCase();
                var str_attr_val = "";

                if (tool_typeof_judge(obj_param_attr[CSTR_KEY_ATTR_VAL],"STRING") && 0 !== obj_param_attr[CSTR_KEY_ATTR_VAL].length) {
                    str_attr_val = obj_param_attr[CSTR_KEY_ATTR_VAL];
                }

                map_res_attribute.set(str_attr_key, str_attr_val);
            }
        }
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    将Json字串转为数据交换对象
   * 参数:
   *    @param { Promise<String> } str_json 参数名称
   * 返回：
   *    @return { Promise<Boolean> }
   *      true 设置成功
   *      false 参数类型错误 或 为空
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_json = function (str_json) {
        if (!tool_typeof_judge(str_json,"STRING") || 0 === str_json.length) {
            return false;
        }
        this.reset();

        // 转化成json对象
        var json_obj = JSON.parse(mc_remove_json_comments(str_json));

        if (!tool_typeof_judge(json_obj,"OBJECT")) {
            return false;
        }

        // 模式判断
        if (tool_typeof_judge(json_obj.COMMAND,"STRING")) {
            this.set_module(true);
        }
        if (tool_typeof_judge(json_obj.CMD,"STRING")) {
            this.set_module(false);
        }

        if (tool_typeof_judge(json_obj[CSTR_KEY_CMD],"STRING")) {
            str_cmd = json_obj[CSTR_KEY_CMD];
        }

        if (tool_typeof_judge(json_obj[CSTR_KEY_FUNC],"STRING")) {
            str_func = json_obj[CSTR_KEY_FUNC];
        }

        var ary_params = json_obj[CSTR_KEY_PARA];

        // ARRAY / OBJECT
        if ("object" !== typeof ary_params || 0 === ary_params.length) {
            return true;
        }

        // 二次判断 只传入PARAMS时
        if (tool_typeof_judge(ary_params[0][CSTR_KEY_ID],"STRING") ) {
            this.set_module(true);
        } else {
            this.set_module(false);
        }

        if (b_easy_flag) {
            param_tool_transform(ary_params);
        } else {
            for (var idx_param = 0; idx_param < ary_params.length; idx_param++) {
                var obj_param = ary_params[idx_param];

                if (!tool_typeof_judge(obj_param,"OBJECT") || !tool_typeof_judge(obj_param[CSTR_KEY_ID],"STRING") || 0 === obj_param[CSTR_KEY_ID].length) {
                    continue;
                }

                var str_param_key = obj_param[CSTR_KEY_ID].toUpperCase();
                var str_param_val = "";

                if (tool_typeof_judge(obj_param[CSTR_KEY_VAL],"STRING") && 0 !== obj_param[CSTR_KEY_VAL].length) {
                    str_param_val = obj_param[CSTR_KEY_VAL];
                }

                var obj_old_val = map_params.get(str_param_key);

                if (!tool_typeof_judge(obj_old_val,"OBJECT")) {
                    obj_old_val = new param_val();
                }
                obj_old_val.str_value = str_param_val;

                decode_attrs(obj_param[CSTR_KEY_ATTR], obj_old_val.map_attributes);
                map_params.set(str_param_key, obj_old_val);
            }
        }


        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    将数据交换对象转换为Json字串
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> } json字串指针
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.10.23
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_json = function () {
        var obj_json = {};

        obj_json[CSTR_KEY_CMD] = str_cmd;
        obj_json[CSTR_KEY_FUNC] = str_func;

        // 创建空数组放置PARAMS
        var ary_param = [];

        for (var idx_param = 0; idx_param < map_params.length(); idx_param++) {
            var str_key = map_params.get_key(idx_param);

            // 不符合 跳过本次
            if (!tool_typeof_judge(str_key,"STRING") || 0 === str_key.length) {
                continue;
            }

            // 创建空对象放置PARAMS子对象
            ary_param[idx_param] = {};
            var obj_param_val = map_params.get(str_key);

            if (b_easy_flag) {
                // 设置Key:Val
                ary_param[idx_param][str_key] = obj_param_val.str_value;
                // ATTRS
                var obj_attr = {};

                for (var idx_easy_attr = 0;
                    idx_easy_attr < obj_param_val.map_attributes.length();
                    idx_easy_attr++
                ) {
                    var str_easy_attr_key = obj_param_val.map_attributes.get_key(idx_easy_attr);

                    if (!tool_typeof_judge(str_easy_attr_key,"STRING") || 0 === str_easy_attr_key.length) {
                        continue;
                    }
                    obj_attr[str_easy_attr_key] = obj_param_val.map_attributes.get(str_easy_attr_key);
                }
                ary_param[idx_param][CSTR_KEY_ATTR] = obj_attr;
            } else {
                // 设置NAME_ID
                ary_param[idx_param][CSTR_KEY_ID] = str_key;
                // 设置VALUE
                ary_param[idx_param][CSTR_KEY_VAL] = obj_param_val.str_value;
                // 创建空数组放置ATTRIBUTE
                var ary_attr = [];

                for (
                    var idx_attr = 0;
                    idx_attr < obj_param_val.map_attributes.length();
                    idx_attr++
                ) {
                    var str_attr_key = obj_param_val.map_attributes.get_key(idx_attr);

                    if (!tool_typeof_judge(str_attr_key,"STRING") || 0 === str_attr_key.length) {
                        continue;
                    }
                    // 创建空对象放置ATTRIBUTE子对象
                    ary_attr[idx_attr] = {};
                    ary_attr[idx_attr][CSTR_KEY_ATTR_NAME] = str_attr_key;
                    ary_attr[idx_attr][
                        CSTR_KEY_ATTR_VAL
                    ] = obj_param_val.map_attributes.get(str_attr_key);
                }
                ary_param[idx_param][CSTR_KEY_ATTR] = ary_attr;
            }
        }
        obj_json[CSTR_KEY_PARA] = ary_param;
        return JSON.stringify(obj_json);
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    切换字串模式
   * 参数:
   *    @param { Promise<String> } b_complex true 开启复杂模式 （默认不开启）
   * 返回：
   *    @return { Promise<Boolean> }
   *      true 设置成功
   *      false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2021.6.29
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_module = function (b_complex) {
        if ("[OBJECT BOOLEAN]" !== Object.prototype.toString.call(b_complex).toUpperCase()) {
            return false;
        }
        if (b_complex) {
            b_easy_flag = false;
            CSTR_KEY_CMD = "COMMAND";
            CSTR_KEY_FUNC = "FUNCTION";
            CSTR_KEY_ATTR = "ATTRIBUTE";
        } else {
            b_easy_flag = true;
            CSTR_KEY_CMD = "CMD";
            CSTR_KEY_FUNC = "FUNC";
            CSTR_KEY_ATTR = "ATTRS";
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    简易模式数据转化
   * 参数:
   *    @param { Promise<Array> } ary_params
   * 返回：
   *    NA
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2021.6.29
   *      内容 : 所有代码
   ************************************************************************************************/
    function param_tool_transform(ary_params) {
        for (var idx_easy_param = 0; idx_easy_param < ary_params.length; idx_easy_param++) {
            var obj_easy_param = ary_params[idx_easy_param];
            var arr_easy_key = Object.keys(obj_easy_param);
            var str_param_key = param_tool_get_key(arr_easy_key);

            for (var idx_param = 0; idx_param < arr_easy_key.length; idx_param++) {
                var str_attr_key = arr_easy_key[idx_param];
                var obj_param = obj_easy_param[str_attr_key];

                // ATTRS
                if (str_attr_key.toUpperCase() === CSTR_KEY_ATTR) {
                    var arr_attr_key = Object.keys(obj_param);

                    for (var idx_attr = 0; idx_attr < arr_attr_key.length; idx_attr++) {
                        var key_u = str_param_key.toUpperCase();
                        var key_attr_u = arr_attr_key[idx_attr];
                        var old_attr_val = map_params.get(key_u);

                        if (tool_typeof_judge(old_attr_val,"UNDEFINED")) {
                            old_attr_val = new param_val();
                        }

                        old_attr_val.map_attributes.set(key_attr_u.toUpperCase(), obj_param[key_attr_u]);
                        map_params.set(key_u, old_attr_val);
                    }
                } else {
                    // NAME_ID VAL
                    var old_val = map_params.get(str_attr_key);

                    if (tool_typeof_judge(old_val,"UNDEFINED")) {
                        old_val = new param_val();
                    }
                    old_val.str_value = obj_param;
                    map_params.set(str_attr_key, old_val);
                }
            }
        }
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取简易模式数据对应NAME_ID
   * 参数:
   *    @param { Promise<Array> } arr_key
   * 返回：
   *    @return { Promise<String> }
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2021.6.29
   *      内容 : 所有代码
   ************************************************************************************************/
    function param_tool_get_key(arr_key) {
        if (!tool_typeof_judge(arr_key,"ARRAY")) {
            return "";
        }
        for (var i = 0; i < arr_key.length; i++) {
            var str_key = arr_key[i].toUpperCase();

            if (str_key !== CSTR_KEY_ATTR) {
                return str_key;
            }
        }
        return "";
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    数据类型判断
 * 参数:
 *    @param { Promise<Data> } data 数据
 *    @param { Promise<String> } str_type 数据类型
 * 返回：
 *    @return { Promise<Boolean> }
 *      true
 *      false
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.6.29
 *      内容 : 所有代码
 ************************************************************************************************/
function tool_typeof_judge(data,str_type) {
    if ("[OBJECT " + str_type + "]" !== Object.prototype.toString.call(data).toUpperCase()) {
        return false;
    }
    return true;
}
